//AIM:To design constant-k high pass filter
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
//We will design constant-k T section high pass filter.
R0=600;//Nominal characteristic impedance in ohms.
disp('ohms',R0,'Considered value of nominal characteristic impedence : R0 = ')
fc=10^4;//Cutoff frequency in Hz.
L=(R0)/(4*%pi*fc);
disp('H',L,'L=')
C=1/(4*%pi*fc*R0);
disp('F',C,'C=')
//Each capacitor in the series arm of T section is 2C
twoC=2*C;
disp('F',twoC,'2C=')

//(i): Computing Z0T:
//We will calculate the characteristic impedence and phase constant 
// at (say) 25KHz
f=25*(10^3);
Z0T=R0*sqrt(1-((fc/f)^2));
disp('ohms',Z0T,'Z0T=')
b=2*asin(fc/f);//b=Beta
b_degrees=b*(180/%pi);
disp('degrees',b_degrees,'Beta=')

//(ii): Computing alpha:
f1=5*(10^3);
alpha=2*(acosh(fc/f1));
disp(alpha,'alpha=')

R01=sqrt(L/C);
disp('ohms',R01,'Calculated value of R0 = ')
if R01==R0 then
    disp('Since the calculated value of the nominal characteristic impedence')
    disp('is the same as the considered value of the nominal characteristic impedence,')
    disp('our design is perfect')
else
    disp('Design is not correct')
end
